<?php
  function getCounter()
  {
    if(!file_exists('/var/wwwdata/licznik.txt')){
      //brak pliku licznika
      return false;
    }
    if(!$fd = fopen('/var/wwwdata/licznik.txt', "r+")){
      //brak dostpu do pliku licznika
      return false;
    }
    if(!flock($fd, LOCK_EX)){
      //nie uzyskano blokady
      fclose($fd);
      return false;
    }
    $count = fgets($fd);
    if(is_numeric($count)){
      $count = (int) ($count + 1);
      ftruncate($fd, 0);
      fseek($fd, 0);
      fputs($fd, $count);
    }
    else{
      //nieprawidowy format odczytanych danych
      $count = false;
    }
    flock($fd, LOCK_UN);
    fclose($fd);
    
    if($count === false){
      return false;
    }

    $imgStr = "";
    $count = strval($count);
    $strLength = strlen($count);
    for($i = 0; $i < $strLength; $i++){
      $temp = "{$count[$i]}" . '.jpg';
      $imgStr .= "<img src='$temp' alt='{$count[$i]}'>";
    }
    
    return $imgStr;
  }
?>
